﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="CS.aspx.cs" Inherits="CS" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.2/css/bootstrap.min.css" />
    <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/json2/20130526/json2.min.js"></script>
    <style type="text/css">
        .freeze
        {
            position: sticky;
            top: 0;
            z-index: 9999;
        }
        .floatleftwithPad
        {
            float: left !important;
            padding: 6px;
        }
        input[type="radio"], input[type="checkbox"]
        {
            line-height: normal;
            margin: 0;
            width: 15px;
            height: 15px;
        }
        
        table.noborder tbody tr td
        {
            border-style: none !important;
        }
        ul#chklisting
        {
            list-style-type: none;
        }
        ul#chklisting li
        {
            float: left;
            text-align: left;
        }
    </style>
</head>
<body>
    <form id="form1" runat="server">
    <div class="container">
        <%--<input type="button" id="btnGenerate" value="Generate Table" />&nbsp;--%>
        <select id="DropDownListcols" class="form-control-sm">
            <option value="0">SELECT</option>
            <option value="1">1</option>
            <option value="2">2</option>
            <option value="3">3</option>
            <option value="4">4</option>
        </select>
        &nbsp;
        <input type="submit" id="submitbutton" value="Submit" class="btn btn-primary btn-sm" />
    </div>
    <hr />
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div id="xmldisplay">
                </div>
                <div id="dvTable">
                </div>
            </div>
        </div>
    </div>
    </form>
    <script type="text/javascript">
        $(function () {
            $("#DropDownListcols").change(function () {
                //Get the count of columns.
                var totalrows = 10;
                var columnCount = $(this).val();
                if (columnCount == 0) {
                    columnCount = 4;
                }
                var colno = 0;
                //Create a HTML Table element.
                var table = '<table class="table table-bordered" id="Mastertable">';
                table += '<thead class="thead-dark freeze">';

                //Create table header according to number of columns
                for (var headcol = 0; headcol < columnCount; headcol++) {
                    table += '<th>Column ' + (headcol + 1).toString() + '</th>';
                }
                table += '</thead>';
                table += '<tbody>';
                for (var j = 0; j < totalrows; j++) {
                    table += '<tr>';
                    for (var z = 0; z < columnCount; z++) {
                        table += '<td>' + GetCheckBoxes(z + 1, j + 1) + '</td>';
                    }
                    table += '</tr>';
                }
                table += '</tbody></table>';
                $("#dvTable").html("");
                $("#dvTable").html(table);
            });

            $("#submitbutton").click(function (e) {
                e.preventDefault();
                SaveXMLDatatoDatabase();
            });
        });

        function SaveXMLDatatoDatabase() {
            var Rows = $('#Mastertable tbody tr');
            var checkedValue = [];
            if (Rows.length > 0) {
                $("input:checkbox[name=cbox]:checked").each(function () {
                    var obj = {};
                    obj.Id = $(this).attr("id");
                    obj.Value = $(this).val();
                    checkedValue.push(obj);
                });

                $.ajax({
                    type: 'POST',
                    url: 'WebService.asmx/InsertChecked',
                    data: JSON.stringify({ details: checkedValue }),
                    contentType: 'application/json; charset=utf-8',
                    DataType: 'json',
                    success: function (r) {
                        alert(r.d);
                    },
                    error: function (r) {
                        alert(r.responseText);
                    }
                });
            }
        }

        function GetCheckBoxes(colcount, rowcount) {
            var str = "";
            //str += '<table class="noborder"><tr>';
            str += '<div class="row"><div class="form-group">'
            for (chk = 0; chk < rowcount; chk++) {
                var chkid = 'Column_' + colcount.toString() + '_Row_' + rowcount.toString() + '_CHKID_' + (chk + 1).toString();
                str += '<label class="col-md-1 checkbox-inline" for="' + chkid.toString() + '">';
                str += '<input class="form-check-input floatleftwithPad" type = "checkbox" style="height:50px; width:5px" value = "' + chkid + '_Value' + '" id = "' + chkid + '" name="cbox">';
                str += '</label>';
            }
            str += '</div></div>';
            return str;
        }
    </script>
</body>
</html>
