﻿using System.Collections.Generic;
using System.Linq;
using EF_Update_MVC_Core.Models;
using Microsoft.AspNetCore.Mvc;

namespace EF_Update_MVC_Core.Controllers
{
    public class HomeController : Controller
    {
        private DBCtx Context { get; }
        public HomeController(DBCtx _context)
        {
            this.Context = _context;
        }

        public IActionResult Index()
        {
            return View();
        }

        [HttpPost]
        public IActionResult Index(Customer customer)
        {
            Customer updatedCustomer = (from c in this.Context.Customers
                                        where c.CustomerId == customer.CustomerId
                                        select c).FirstOrDefault();

            if (updatedCustomer != null)
            {
                updatedCustomer.Name = customer.Name;
                updatedCustomer.Country = customer.Country;
                this.Context.SaveChanges();
                ViewBag.Message = "Customer record updated.";
            }
            else
            {
                ViewBag.Message = "Customer not found.";
            }

            return View();
        }
    }
}