﻿Imports System.Data
Imports System.Drawing

Partial Class VB
    Inherits System.Web.UI.Page
    Protected Sub Page_Load(sender As Object, e As EventArgs) Handles Me.Load
        If Not IsPostBack Then
            Dim dt As New DataTable()
            dt.Columns.AddRange(New DataColumn(1) {New DataColumn("Item"), New DataColumn("Quantity")})
            dt.Rows.Add("Shirt", 145)
            dt.Rows.Add("Jeans", 0)
            dt.Rows.Add("Trousers", 190)
            dt.Rows.Add("Tie", 30)
            dt.Rows.Add("Cap", 0)
            dt.Rows.Add("Hat", 90)
            dt.Rows.Add("Scarf", 290)
            dt.Rows.Add("Belt", 150)
            GridView1.DataSource = dt
            GridView1.DataBind()
        End If
    End Sub

    Protected Sub OnRowDataBound(sender As Object, e As GridViewRowEventArgs)
        If e.Row.RowType = DataControlRowType.DataRow Then
            Dim quantity As Integer = Integer.Parse(e.Row.Cells(1).Text)

            For Each cell As TableCell In e.Row.Cells
                If quantity = 0 Then
                    cell.BackColor = Color.Red
                End If
                If quantity > 0 AndAlso quantity <= 50 Then
                    cell.BackColor = Color.Yellow
                End If
                If quantity > 50 AndAlso quantity <= 100 Then
                    cell.BackColor = Color.Orange
                End If
            Next
        End If
    End Sub
End Class
