﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Drawing;

public partial class CS : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            DataTable dt = new DataTable();
            dt.Columns.AddRange(new DataColumn[2] { new DataColumn("Item"), new DataColumn("Quantity") });
            dt.Rows.Add("Shirt", 145);
            dt.Rows.Add("Jeans", 0);
            dt.Rows.Add("Trousers", 190);
            dt.Rows.Add("Tie", 30);
            dt.Rows.Add("Cap", 0);
            dt.Rows.Add("Hat", 90);
            dt.Rows.Add("Scarf", 290);
            dt.Rows.Add("Belt", 150);
            GridView1.DataSource = dt;
            GridView1.DataBind();
        }
    }

    protected void OnRowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            int quantity = int.Parse(e.Row.Cells[1].Text);

            foreach (TableCell cell in e.Row.Cells)
            {
                if (quantity == 0)
                {
                    cell.BackColor = Color.Red;
                }
                if (quantity > 0 && quantity <= 50)
                {
                    cell.BackColor = Color.Yellow;
                }
                if (quantity > 50 && quantity <= 100)
                {
                    cell.BackColor = Color.Orange;
                }
            }
        }
    }
}