﻿Imports System.Data
Imports System.Configuration
Imports System.Data.SqlClient

Partial Class VB
    Inherits System.Web.UI.Page
    Protected Sub Page_Load(sender As Object, e As EventArgs) Handles Me.Load
        If Not IsPostBack Then
            Me.BindGrid()
        End If
    End Sub

    Private Sub BindGrid()
        Dim constr As String = ConfigurationManager.ConnectionStrings("constr").ConnectionString
        Using con As New SqlConnection(constr)
            Using cmd As New SqlCommand("SELECT [HobbyId], [Description], [IsSelected] FROM Hobbies")
                Using sda As New SqlDataAdapter()
                    cmd.Connection = con
                    sda.SelectCommand = cmd
                    Using dt As New DataTable()
                        sda.Fill(dt)
                        GridView1.DataSource = dt
                        GridView1.DataBind()
                    End Using
                End Using
            End Using
        End Using
    End Sub

    Protected Sub Save(sender As Object, e As EventArgs)
        Dim constr As String = ConfigurationManager.ConnectionStrings("constr").ConnectionString
        Using con As New SqlConnection(constr)
            Using cmd As New SqlCommand()
                cmd.CommandText = "UPDATE hobbies SET [IsSelected] = @IsSelected WHERE HobbyId=@HobbyId"
                cmd.Connection = con
                con.Open()
                For Each row As GridViewRow In GridView1.Rows
                    'Get the HobbyId from the DataKey property.
                    Dim hobbyId As Integer = Convert.ToInt32(GridView1.DataKeys(row.RowIndex).Values(0))

                    'Get the checked value of the CheckBox.
                    Dim isSelected As Boolean = TryCast(row.FindControl("chkSelect"), CheckBox).Checked

                    'Save to database.
                    cmd.Parameters.Clear()
                    cmd.Parameters.AddWithValue("@HobbyId", hobbyId)
                    cmd.Parameters.AddWithValue("@IsSelected", isSelected)
                    cmd.ExecuteNonQuery()
                Next
                con.Close()
                Response.Redirect(Request.Url.AbsoluteUri)
            End Using
        End Using
    End Sub
End Class
