﻿using System;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using System.Data;
using System.Configuration;
using System.Data.SqlClient;

public partial class CS : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            this.BindGrid();
        }
    }

    private void BindGrid()
    {
        string constr = ConfigurationManager.ConnectionStrings["constr"].ConnectionString;
        using (SqlConnection con = new SqlConnection(constr))
        {
            using (SqlCommand cmd = new SqlCommand("SELECT [HobbyId], [Description], [IsSelected] FROM Hobbies"))
            {
                using (SqlDataAdapter sda = new SqlDataAdapter())
                {
                    cmd.Connection = con;
                    sda.SelectCommand = cmd;
                    using (DataTable dt = new DataTable())
                    {
                        sda.Fill(dt);
                        GridView1.DataSource = dt;
                        GridView1.DataBind();
                    }
                }
            }
        }
    }

    protected void Save(object sender, EventArgs e)
    {
        string constr = ConfigurationManager.ConnectionStrings["constr"].ConnectionString;
        using (SqlConnection con = new SqlConnection(constr))
        {
            using (SqlCommand cmd = new SqlCommand())
            {
                cmd.CommandText = "UPDATE Hobbies SET [IsSelected] = @IsSelected WHERE HobbyId=@HobbyId";
                cmd.Connection = con;
                con.Open();
                foreach (GridViewRow row in GridView1.Rows)
                {
                    //Get the HobbyId from the DataKey property.
                    int hobbyId = Convert.ToInt32(GridView1.DataKeys[row.RowIndex].Values[0]);

                    //Get the checked value of the CheckBox.
                    bool isSelected = (row.FindControl("chkSelect") as CheckBox).Checked;

                    //Save to database.
                    cmd.Parameters.Clear();
                    cmd.Parameters.AddWithValue("@HobbyId", hobbyId);
                    cmd.Parameters.AddWithValue("@IsSelected", isSelected);
                    cmd.ExecuteNonQuery();
                }
                con.Close();
                Response.Redirect(Request.Url.AbsoluteUri);
            }
        }
    }
}