﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="Default.aspx.cs" Inherits="_Default" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <style type="text/css">
        body
        {
            font-family: Arial;
            font-size: 10pt;
        }
    </style>
</head>
<body>
    <form id="form1" runat="server">
    <u>1. Using Regular Expression Validator</u>
    <hr />
    <asp:TextBox ID="TextBox1" runat="server" />
    <br />
    <asp:RegularExpressionValidator ID="RegularExpressionValidator1" runat="server" ControlToValidate="TextBox1"
        ForeColor="Red" ValidationExpression="[a-zA-Z0-9%*#]*$" ErrorMessage="Valid characters: Alphabets, Numbers and '%*#' characters." />
    <br />
    <asp:Button ID="Button1" Text="Validate" runat="server" />
    <br />
    <br />
    <u>2. Using Regular Expression and JavaScript</u>
    <hr />
    <asp:TextBox ID="TextBox2" runat="server" />
    <br />
    <span id="spnError" style="color: Red; display: none">Valid characters: Alphabets, Numbers and '%*#' characters.</span>
    <br />
    <asp:Button ID="Button2" Text="Validate" runat="server" CausesValidation="false"
        OnClientClick="return Validate()" />
    <script type="text/javascript">
        function Validate() {
            var isValid = false;
            var regex = /^[a-zA-Z0-9%*#]*$/;
            isValid = regex.test(document.getElementById("<%=TextBox2.ClientID %>").value);
            document.getElementById("spnError").style.display = !isValid ? "block" : "none";
            return isValid;
        }
    </script>
    <br />
    <br />
    <u>3. Using Regular Expression and jQuery</u>
    <hr />
    <asp:TextBox ID="TextBox3" runat="server" />
    <br />
    <span id="spnError2" style="color: Red; display: none">*Valid characters: Alphabets, Numbers and '%*#' characters.</span>
    <br />
    <asp:Button ID="btnValidate" Text="Validate" runat="server" CausesValidation="false" />
    <script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.8.3/jquery.min.js"></script>
    <script type="text/javascript">
        $(function () {
            $("[id*=btnValidate]").bind("click", function () {
                var isValid = false;
                var regex = /^[a-zA-Z0-9%*#]*$/;
                isValid = regex.test($("[id*=TextBox3]").val());
                $("#spnError2").css("display", !isValid ? "block" : "none");
                return isValid;
            });
        });
    </script>
    </form>
</body>
</html>
