﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Export_Word_MVC_Core.Models;
using System.Text;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;

namespace Export_Word_MVC_Core.Controllers
{
    public class HomeController : Controller
    {
        private DBCtx Context { get; }
        private IHttpContextAccessor Accessor;

        public HomeController(DBCtx _context, IHttpContextAccessor _accessor)
        {
            this.Context = _context;
            this.Accessor = _accessor;
        }

        public IActionResult Index()
        {
            return View(this.Context.Customers.Take(10).ToList());
        }

        [HttpPost]
        public EmptyResult Export(string GridHtml)
        {
            byte[] bytes = Encoding.UTF8.GetBytes(GridHtml);
            HttpContext context = this.Accessor.HttpContext;
            context.Response.Clear();
            context.Response.Headers.Add("content-disposition", "attachment;filename=Grid.doc");
            context.Response.ContentType = "application/vnd.ms-word";
            context.Response.Body.Write(bytes, 0, bytes.Length);
            return new EmptyResult();
        }
    }
}