﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.RazorPages;
using Insert_File_Database_EF_Razor_Core.Models;
using System.IO;
using Microsoft.AspNetCore.Http;

namespace Insert_File_Database_EF_Razor_Core.Pages
{
    public class IndexModel : PageModel
    {
        private DBCtx Context { get; }
        public IndexModel(DBCtx _context)
        {
            this.Context = _context;
        }

        public void OnGet()
        {

        }

        public void OnPostUpload(IFormFile postedFile)
        {
            string fileName = Path.GetFileName(postedFile.FileName);
            string contentType = postedFile.ContentType;
            using (MemoryStream ms = new MemoryStream())
            {
                postedFile.CopyTo(ms);
                this.Context.tblFiles.Add(new FileModel
                {
                    Name = fileName,
                    ContentType = contentType,
                    Data = ms.ToArray()
                });
                this.Context.SaveChanges();
            }
        }
    }
}