﻿Imports ASPSnippets.FaceBookAPI
Imports System.Collections.Generic
Imports System.Web.Script.Serialization

Partial Class VB
    Inherits System.Web.UI.Page
    Protected Sub Page_Load(sender As Object, e As EventArgs) Handles Me.Load
        FaceBookConnect.API_Key = "<Your API Key>"
        FaceBookConnect.API_Secret = "<Your API Secret>"
        If Not IsPostBack Then
            Dim code As String = Request.QueryString("code")
            If Not String.IsNullOrEmpty(code) Then
                Dim data As String = FaceBookConnect.Fetch(code, "me?fields=taggable_friends")
                Dim facebookData As FaceBookData = New JavaScriptSerializer().Deserialize(Of FaceBookData)(data)
                gvFriends.DataSource = facebookData.Taggable_Friends.Data
                gvFriends.DataBind()
            End If
        End If
    End Sub
    Protected Sub btnFetch_Click(sender As Object, e As EventArgs)
        FaceBookConnect.Authorize("user_photos,user_friends", Request.Url.AbsoluteUri)
    End Sub

End Class

Public Class FaceBookData
    Public Property Taggable_Friends() As TaggableFriends
End Class

Public Class TaggableFriends
    Public Property Data() As List(Of FaceBookUser)
End Class

Public Class FaceBookUser

    Public Property Id() As String
    Public Property Name() As String
    Public Property Picture As Picture
    Public ReadOnly Property PictureUrl() As String
        Get
            Return Me.Picture.Data.Url
        End Get
    End Property
End Class

Public Class Picture
    Public Property Data() As FaceBookUserPicture
End Class

Public Class FaceBookUserPicture
    Public Property Url() As String
End Class