﻿using System;

using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Net;
using ASPSnippets.FaceBookAPI;
using System.Collections.Generic;
using System.Web.Script.Serialization;
public partial class CS : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        FaceBookConnect.API_Key = "<Your API Key>";
        FaceBookConnect.API_Secret = "<Your API Secret>";
        if (!IsPostBack)
        {
            string code = Request.QueryString["code"];
            if (!string.IsNullOrEmpty(code))
            {
                string data = FaceBookConnect.Fetch(code, "me?fields=taggable_friends");
                FaceBookData facebookData = new JavaScriptSerializer().Deserialize<FaceBookData>(data);
                gvFriends.DataSource = facebookData.Taggable_Friends.Data;
                gvFriends.DataBind();
            }
        }
    }
    protected void btnFetch_Click(object sender, EventArgs e)
    {
        FaceBookConnect.Authorize("user_photos,user_friends", Request.Url.AbsoluteUri);
    }

}


public class FaceBookData
{
    public TaggableFriends Taggable_Friends { get; set; }
}

public class TaggableFriends
{
    public List<FaceBookUser> Data { get; set; }
}

public class FaceBookUser
{
    public string Id { get; set; }
    public string Name { get; set; }
    public Picture Picture { get; set; }
    public string PictureUrl
    {
        get
        {
            return this.Picture.Data.Url;
        }
    }
}

public class Picture
{
    public FaceBookUserPicture Data { get; set; }
}

public class FaceBookUserPicture
{
    public string Url { get; set; }
}