﻿
Imports System.Data.SqlClient
Imports System.Configuration

Partial Class VB
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(sender As Object, e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            gvCustomers.DataSource = Me.GetCustomers
            gvCustomers.DataBind()
        End If
    End Sub

    Private Function GetCustomers() As List(Of Customer)
        Dim constr As String = ConfigurationManager.ConnectionStrings("constr").ConnectionString
        Dim sql As String = "SELECT CustomerId, Name, Country FROM Customers"
        Using con As New SqlConnection(constr)
            Using cmd As New SqlCommand(sql, con)
                Dim customers As New List(Of Customer)
                con.Open()
                Using sdr As SqlDataReader = cmd.ExecuteReader()
                    While sdr.Read()
                        customers.Add(New Customer With {
                                        .CustomerId = Convert.ToInt32(sdr("CustomerId")),
                                        .Name = sdr("Name").ToString(),
                                        .Country = sdr("Country").ToString()
                                    })
                    End While
                End Using
                con.Close()
                Return customers
            End Using
        End Using
    End Function

    Public Class Customer
        Public Property CustomerId As Integer
        Public Property Name As String
        Public Property Country As String
    End Class
End Class
