﻿using System;
using System.Collections.Generic;

using System.Data.SqlClient;
using System.Configuration;


public partial class CS : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.IsPostBack)
        {
            gvCustomers.DataSource = this.GetCustomers();
            gvCustomers.DataBind();
        }
    }

    private List<Customer> GetCustomers()
    {
        string constr = ConfigurationManager.ConnectionStrings["constr"].ConnectionString;
        string sql = "SELECT CustomerId, Name, Country FROM Customers";
        using (SqlConnection con = new SqlConnection(constr))
        {
            using (SqlCommand cmd = new SqlCommand(sql, con))
            {
                List<Customer> customers = new List<Customer>();
                con.Open();
                using (SqlDataReader sdr = cmd.ExecuteReader())
                {
                    while (sdr.Read())
                    {
                        customers.Add(new Customer
                        {
                            CustomerId = Convert.ToInt32(sdr["CustomerId"]),
                            Name = sdr["Name"].ToString(),
                            Country = sdr["Country"].ToString()
                        });
                    }
                }
                con.Close();
                return customers;
            }
        }
    }

    public class Customer
    {
        public int CustomerId { get; set; }
        public string Name { get; set; }
        public string Country { get; set; }
    }
}