﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.RazorPages;
using Razor_ComboBox_jQuery.Models;

using Microsoft.AspNetCore.Mvc.Rendering;


namespace Razor_ComboBox_jQuery.Pages
{
    public class IndexModel : PageModel
    {
        private DBCtx Context { get; }
        public IndexModel(DBCtx _context)
        {
            this.Context = _context;
        }

        public SelectList Customers { get; set; }

        public void OnGet()
        {
            this.Customers = new SelectList(this.Context.Customers, "CustomerId", "Name");
        }

        public void OnPostSubmit(string customerId, string customerName)
        {
            this.Customers = new SelectList(this.Context.Customers, "CustomerId", "Name");
            string message = "Name: " + customerName;
            message += "\\nID: " + customerId;
            ViewData["Message"] = message;
        }

    }
}