﻿Imports System.Data
Imports System.Data.SqlClient
Imports System.Configuration

Partial Class VB
    Inherits System.Web.UI.Page
    Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs) Handles Me.Load
        If Not Me.IsPostBack Then
            rptCustomers.DataSource = Me.GetData("SELECT TOP 10 CustomerId, ContactName, Country FROM Customers")
            rptCustomers.DataBind()
        End If
    End Sub

    Private Function GetData(ByVal query As String) As DataTable
        Dim constr As String = ConfigurationManager.ConnectionStrings("constr").ConnectionString
        Using con As SqlConnection = New SqlConnection(constr)
            Using cmd As SqlCommand = New SqlCommand(query, con)
                Using sda As SqlDataAdapter = New SqlDataAdapter(cmd)
                    Dim dt As DataTable = New DataTable()
                    sda.Fill(dt)
                    Return dt
                End Using
            End Using
        End Using
    End Function

    Protected Sub OnItemDataBound(ByVal sender As Object, ByVal e As RepeaterItemEventArgs)
        If e.Item.ItemType = ListItemType.Item OrElse e.Item.ItemType = ListItemType.AlternatingItem Then
            'Find the DropDownList in the Repeater Item.
            Dim ddlCountries As DropDownList = (TryCast(e.Item.FindControl("ddlCountries"), DropDownList))
            ddlCountries.DataSource = Me.GetData("SELECT DISTINCT Country FROM Customers")
            ddlCountries.DataTextField = "Country"
            ddlCountries.DataValueField = "Country"
            ddlCountries.DataBind()

            'Add Default Item in the DropDownList.
            ddlCountries.Items.Insert(0, New ListItem("Please select"))

            'Select the Country of Customer in DropDownList.
            Dim country As String = (TryCast(e.Item.DataItem, DataRowView))("Country").ToString()
            ddlCountries.Items.FindByValue(country).Selected = True
        End If
    End Sub
End Class
