﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using System.Data;
using System.Data.SqlClient;
using System.Configuration;

public partial class CS : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.IsPostBack)
        {
            rptCustomers.DataSource = this.GetData("SELECT TOP 10 CustomerId, ContactName, Country FROM Customers");
            rptCustomers.DataBind();
        }
    }

    private DataTable GetData(string query)
    {
        string constr = ConfigurationManager.ConnectionStrings["constr"].ConnectionString;
        using (SqlConnection con = new SqlConnection(constr))
        {
            using (SqlCommand cmd = new SqlCommand(query, con))
            {
                using (SqlDataAdapter sda = new SqlDataAdapter(cmd))
                {
                    DataTable dt = new DataTable();
                    sda.Fill(dt);
                    return dt;
                }
            }
        }
    }

    protected void OnItemDataBound(object sender, RepeaterItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
        {
            //Find the DropDownList in the Repeater Item.
            DropDownList ddlCountries = (e.Item.FindControl("ddlCountries") as DropDownList);
            ddlCountries.DataSource = this.GetData("SELECT DISTINCT Country FROM Customers");
            ddlCountries.DataTextField = "Country";
            ddlCountries.DataValueField = "Country";
            ddlCountries.DataBind();

            //Add Default Item in the DropDownList.
            ddlCountries.Items.Insert(0, new ListItem("Please select"));

            //Select the Country of Customer in DropDownList.
            string country = (e.Item.DataItem as DataRowView)["Country"].ToString();
            ddlCountries.Items.FindByValue(country).Selected = true;
        }
    }
}