﻿Imports System.Net
Imports System.Data
Imports System.Net.Mail
Imports System.Configuration
Imports System.Net.Configuration
Public Class Form1

    Private Sub Form1_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        Dim dt As New DataTable()
        dt.Columns.AddRange(New DataColumn() {New DataColumn("Id", GetType(Integer)),
                                              New DataColumn("Name", GetType(String)),
                                              New DataColumn("Country", GetType(String))})
        dt.Rows.Add(1, "John Hammond", "United States")
        dt.Rows.Add(2, "Mudassar Khan", "India")
        dt.Rows.Add(3, "Suzanne Mathews", "France")
        dt.Rows.Add(4, "Robert Schidner", "Russia")
        Me.dataGridView1.DataSource = dt
        Me.dataGridView1.AllowUserToAddRows = False
    End Sub

    Private Sub btnSend_Click(sender As System.Object, e As System.EventArgs) Handles btnSend.Click
        'Table start.
        Dim html As String = "<table cellpadding='5' cellspacing='0' style='border: 1px solid #ccc;font-size: 9pt'>"

        'Adding HeaderRow.
        html &= "<tr>"

        For Each column As DataGridViewColumn In dataGridView1.Columns
            html &= "<th style='background-color: #B8DBFD;border: 1px solid #ccc'>" & column.HeaderText & "</th>"
        Next
        html &= "</tr>"

        'Adding DataRow.
        For Each row As DataGridViewRow In dataGridView1.Rows
            html &= "<tr>"

            For Each cell As DataGridViewCell In row.Cells
                html &= "<td style='width:120px;border: 1px solid #ccc'>" & cell.Value.ToString() & "</td>"
            Next

            html &= "</tr>"
        Next

        'Table end.
        html &= "</table>"

        'Read SMTP section from App.Config.
        Dim smtpSection As SmtpSection = CType(ConfigurationManager.GetSection("system.net/mailSettings/smtp"), SmtpSection)

        'Sending the DataGridView's HTML in Email.
        Using mm As MailMessage = New MailMessage(smtpSection.From, "recipient@gmail.com")
            mm.Subject = "DataGridView"
            mm.Body = html
            mm.IsBodyHtml = True

            Using smtp As SmtpClient = New SmtpClient()
                smtp.Host = smtpSection.Network.Host
                smtp.Port = smtpSection.Network.Port
                smtp.EnableSsl = smtpSection.Network.EnableSsl
                smtp.UseDefaultCredentials = smtpSection.Network.DefaultCredentials
                smtp.Credentials = New NetworkCredential(smtpSection.Network.UserName, smtpSection.Network.Password)
                smtp.Send(mm)
                MessageBox.Show("Email sent.", "Message")
            End Using
        End Using
    End Sub
End Class
