﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.Net;
using System.Data;
using System.Net.Mail;
using System.Configuration;
using System.Net.Configuration;

namespace DataGridView_Email_CS
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

    private void Form1_Load(object sender, EventArgs e)
    {
        DataTable dt = new DataTable();
        dt.Columns.AddRange(new DataColumn[3] {
                            new DataColumn("Id", typeof(int)),
                            new DataColumn("Name", typeof(string)),
                            new DataColumn("Country", typeof(string))
                        });
        dt.Rows.Add(1, "John Hammond", "United States");
        dt.Rows.Add(2, "Mudassar Khan", "India");
        dt.Rows.Add(3, "Suzanne Mathews", "France");
        dt.Rows.Add(4, "Robert Schidner", "Russia");
        this.dataGridView1.DataSource = dt;
        this.dataGridView1.AllowUserToAddRows = false;
    }

private void btnSend_Click(object sender, EventArgs e)
{
    //Table start.
    string html = "<table cellpadding='5' cellspacing='0' style='border: 1px solid #ccc;font-size: 9pt'>";

    //Adding HeaderRow.
    html += "<tr>";
    foreach (DataGridViewColumn column in dataGridView1.Columns)
    {
        html += "<th style='background-color: #B8DBFD;border: 1px solid #ccc'>" + column.HeaderText + "</th>";
    }
    html += "</tr>";

    //Adding DataRow.
    foreach (DataGridViewRow row in dataGridView1.Rows)
    {
        html += "<tr>";
        foreach (DataGridViewCell cell in row.Cells)
        {
            html += "<td style='width:120px;border: 1px solid #ccc'>" + cell.Value.ToString() + "</td>";
        }
        html += "</tr>";
    }

    //Table end.
    html += "</table>";

    //Read SMTP section from App.Config.
    SmtpSection smtpSection = (SmtpSection)ConfigurationManager.GetSection("system.net/mailSettings/smtp");

    //Sending the DataGridView's HTML in Email.
    using (MailMessage mm = new MailMessage(smtpSection.From, "recipient@gmail.com"))
    {
        mm.Subject = "DataGridView";
        mm.Body = html;
        mm.IsBodyHtml = true;
        using (SmtpClient smtp = new SmtpClient())
        {
            smtp.Host = smtpSection.Network.Host;
            smtp.Port = smtpSection.Network.Port;
            smtp.EnableSsl = smtpSection.Network.EnableSsl;
            smtp.UseDefaultCredentials = smtpSection.Network.DefaultCredentials;
            smtp.Credentials = new NetworkCredential(smtpSection.Network.UserName, smtpSection.Network.Password);
            smtp.Send(mm);
            MessageBox.Show("Email sent.", "Message");
        }
    }
}
    }
}
