﻿using System.ComponentModel.DataAnnotations;

namespace US_MobileNumber_Validation_MVC_Core.Models
{
    public class PersonModel
    {
        [Display(Name = "Mobile Number: ")]
        [Required(ErrorMessage = "Invalid Mobile Number.")]
        [RegularExpression(@"^(\([0-9]{3}\)|[0-9]{3})[\s\-]?[\0-9]{3}[\s\-]?[0-9]{4}$", ErrorMessage = "Invalid Mobile Number.")]
        public string MobileNumber { get; set; }
    }
}
