using ContactForm_Email_Razor_Core.Models;
using Microsoft.AspNetCore.Mvc.RazorPages;

using System.Net;
using System.Net.Mail;

namespace ContactForm_Email_Razor_Core.Pages
{
    public class IndexModel : PageModel
    {
        public string Message { get; set; }

        private IConfiguration Configuration;
        public IndexModel(IConfiguration _configuration)
        {
            this.Configuration = _configuration;
        }

        public void OnGet()
        {

        }

        public void OnPostSubmit(ContactFormModel model)
        {
            //Read SMTP settings from AppSettings.json.
            string host = this.Configuration.GetValue<string>("Smtp:Server");
            int port = this.Configuration.GetValue<int>("Smtp:Port");
            string fromAddress = this.Configuration.GetValue<string>("Smtp:FromAddress");
            string userName = this.Configuration.GetValue<string>("Smtp:UserName");
            string password = this.Configuration.GetValue<string>("Smtp:Password");
            bool enableSsl = this.Configuration.GetValue<bool>("Smtp:EnableSsl");
            bool defaultCredentials = this.Configuration.GetValue<bool>("Smtp:DefaultCredentials");

            using (MailMessage mm = new MailMessage(fromAddress, "admin@aspsnippets.com"))
            {
                mm.Subject = model.Subject;
                mm.Body = "Name: " + model.Name + "<br /><br />Email: " + model.Email + "<br />" + model.Body;
                mm.IsBodyHtml = true;

                if (model.Attachment.Length > 0)
                {
                    string fileName = Path.GetFileName(model.Attachment.FileName);
                    mm.Attachments.Add(new Attachment(model.Attachment.OpenReadStream(), fileName));
                }

                using (SmtpClient smtp = new SmtpClient())
                {
                    smtp.Host = host;
                    smtp.Port = port;
                    smtp.EnableSsl = enableSsl;
                    smtp.UseDefaultCredentials = defaultCredentials;
                    smtp.Credentials = new NetworkCredential(userName, password);
                    smtp.Send(mm);
                    this.Message = "Email sent sucessfully.";
                }
            }
        }
    }
}