Imports System.IO
Imports System.Data
Imports System.Data.OleDb
Imports System.Configuration

Partial Class VB
    Inherits System.Web.UI.Page

    Protected Sub OnUpload(sender As Object, e As EventArgs)
        If fuUpload.HasFile Then
            Dim fileName As String = Path.GetFileName(fuUpload.PostedFile.FileName)
            Dim extension As String = Path.GetExtension(fuUpload.PostedFile.FileName)
            Dim filePath As String = Server.MapPath("~/Files/" & fileName)
            fuUpload.SaveAs(filePath)
            Me.ImportToGrid(filePath, extension, rbHDR.SelectedItem.Text)
        End If
    End Sub

    Private Sub ImportToGrid(filePath As String, extension As String, isHDR As String)
        Dim conString As String = ""
        Select Case extension 'Excel 97-03
            Case ".xls"
                conString = ConfigurationManager.ConnectionStrings("Excel03ConString").ConnectionString
            Case ".xlsx" 'Excel 07
                conString = ConfigurationManager.ConnectionStrings("Excel07ConString").ConnectionString
        End Select

        conString = String.Format(conString, filePath, isHDR)
        Using connExcel As OleDbConnection = New OleDbConnection(conString)
            Using cmdExcel As OleDbCommand = New OleDbCommand()
                Using oda As OleDbDataAdapter = New OleDbDataAdapter()
                    Using dt As DataTable = New DataTable()
                        cmdExcel.Connection = connExcel

                        'Get the name of First Sheet.
                        connExcel.Open()
                        Dim dtExcelSchema As DataTable = connExcel.GetOleDbSchemaTable(OleDbSchemaGuid.Tables, Nothing)
                        Dim sheetName As String = dtExcelSchema.Rows(0)("TABLE_NAME").ToString()
                        connExcel.Close()

                        'Read Data from First Sheet.
                        connExcel.Open()
                        cmdExcel.CommandText = "SELECT * From [" & sheetName & "]"
                        oda.SelectCommand = cmdExcel
                        oda.Fill(dt)
                        connExcel.Close()

                        'Bind Data to GridView.
                        gvCustomers.Caption = Path.GetFileName(filePath)
                        gvCustomers.DataSource = dt
                        gvCustomers.DataBind()
                    End Using
                End Using
            End Using
        End Using
    End Sub
End Class
