using System;

using System.IO;
using System.Data;
using System.Data.OleDb;
using System.Configuration;

public partial class CS : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {

    }

    protected void OnUpload(object sender, EventArgs e)
    {
        if (fuUpload.HasFile)
        {
            string fileName = Path.GetFileName(fuUpload.PostedFile.FileName);
            string extension = Path.GetExtension(fuUpload.PostedFile.FileName);
            string filePath = Server.MapPath("~/Files/" + fileName);
            fuUpload.SaveAs(filePath);
            this.ImportToGrid(filePath, extension, rbHDR.SelectedItem.Text);
        }
    }

    private void ImportToGrid(string filePath, string extension, string isHDR)
    {
        string conString = "";
        switch (extension)
        {
            case ".xls": //Excel 97-03
                conString = ConfigurationManager.ConnectionStrings["Excel03ConString"].ConnectionString;
                break;
            case ".xlsx": //Excel 07
                conString = ConfigurationManager.ConnectionStrings["Excel07ConString"].ConnectionString;
                break;
        }
        conString = string.Format(conString, filePath, isHDR);
        using (OleDbConnection connExcel = new OleDbConnection(conString))
        {
            using (OleDbCommand cmdExcel = new OleDbCommand())
            {
                using (OleDbDataAdapter oda = new OleDbDataAdapter())
                {
                    using (DataTable dt = new DataTable())
                    {
                        cmdExcel.Connection = connExcel;

                        //Get the name of First Sheet.
                        connExcel.Open();
                        DataTable dtExcelSchema = connExcel.GetOleDbSchemaTable(OleDbSchemaGuid.Tables, null);
                        string sheetName = dtExcelSchema.Rows[0]["TABLE_NAME"].ToString();
                        connExcel.Close();

                        //Read Data from First Sheet.
                        connExcel.Open();
                        cmdExcel.CommandText = "SELECT * From [" + sheetName + "]";
                        oda.SelectCommand = cmdExcel;
                        oda.Fill(dt);
                        connExcel.Close();

                        //Bind Data to GridView.
                        gvCustomers.Caption = Path.GetFileName(filePath);
                        gvCustomers.DataSource = dt;
                        gvCustomers.DataBind();
                    }
                }
            }
        }
    }
}
