﻿Imports System.Data
Imports System.Data.SqlClient
Imports System.Collections.Generic
Partial Class VB
    Inherits System.Web.UI.Page
    Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs) Handles Me.Load
        If Not IsPostBack Then
            ViewState("CurrentAlphabet") = "ALL"
            Me.GenerateAlphabets()
            Me.BindDataList()
        End If
    End Sub

    Private Sub BindDataList()
        Dim conStr As String = ConfigurationManager _
                .ConnectionStrings("conStr").ConnectionString
        Dim con As New SqlConnection(conStr)
        Dim cmd As New SqlCommand("spx_GetContacts")
        cmd.Connection = con
        cmd.CommandType = CommandType.StoredProcedure
        cmd.Parameters.AddWithValue("@Alphabet", ViewState("CurrentAlphabet"))
        con.Open()
        dlContacts.DataSource = cmd.ExecuteReader()
        dlContacts.DataBind()
        con.Close()

        If ViewState("CurrentAlphabet").ToString().Equals("ALL") Then
            lblView.Text = "all Contacts."
        Else
            lblView.Text = "Contacts whose name starts with " & _
                    ViewState("CurrentAlphabet").ToString()
        End If
    End Sub
    Private Sub GenerateAlphabets()
        Dim alphabets As New List(Of Alphabet)()
        Dim alphabet As New Alphabet()
        alphabet.Value = "ALL"
        alphabet.isNotSelected = Not alphabet.Value _
                    .Equals(ViewState("CurrentAlphabet"))
        alphabets.Add(alphabet)
        For i As Integer = 65 To 90
            alphabet = New Alphabet()
            alphabet.Value = [Char].ConvertFromUtf32(i)
            alphabet.isNotSelected = Not alphabet.Value _
                    .Equals(ViewState("CurrentAlphabet"))
            alphabets.Add(alphabet)
        Next
        rptAlphabets.DataSource = alphabets
        rptAlphabets.DataBind()
    End Sub

    Protected Sub Alphabet_Click(ByVal sender As Object, ByVal e As EventArgs)
        Dim lnkAlphabet As LinkButton = DirectCast(sender, LinkButton)
        ViewState("CurrentAlphabet") = lnkAlphabet.Text
        Me.GenerateAlphabets()
        Me.BindDataList()
    End Sub
End Class


