﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data.SqlClient;
using System.Configuration;
using System.Data;

public partial class _Default : System.Web.UI.Page 
{
protected void Page_Load(object sender, EventArgs e)
{
    if (!IsPostBack)
    {
        ViewState["CurrentAlphabet"] = "ALL";
        this.GenerateAlphabets();
        this.BindDataList();
    }
}

private void BindDataList()
{
    string conStr = ConfigurationManager
            .ConnectionStrings["conStr"].ConnectionString;
    SqlConnection con = new SqlConnection(conStr);
    SqlCommand cmd = new SqlCommand("spx_GetContacts");
    cmd.Connection = con;
    cmd.CommandType = CommandType.StoredProcedure;
    cmd.Parameters.AddWithValue("@Alphabet", ViewState["CurrentAlphabet"]);
    con.Open();
    dlContacts.DataSource = cmd.ExecuteReader();
    dlContacts.DataBind();
    con.Close();

    if (ViewState["CurrentAlphabet"].ToString().Equals("ALL"))
        lblView.Text = "all Contacts.";
    else
        lblView.Text = "Contacts whose name starts with " 
                    + ViewState["CurrentAlphabet"].ToString();
}
private void GenerateAlphabets()
{
    List<Alphabet> alphabets = new List<Alphabet>();
    Alphabet alphabet = new Alphabet();
    alphabet.Value = "ALL";
    alphabet.isNotSelected = !alphabet.Value
                .Equals(ViewState["CurrentAlphabet"]);
    alphabets.Add(alphabet);
    for (int i = 65; i <= 90; i++)
    {
        alphabet = new Alphabet();
        alphabet.Value = Char.ConvertFromUtf32(i);
        alphabet.isNotSelected = !alphabet.Value
                .Equals(ViewState["CurrentAlphabet"]);
        alphabets.Add(alphabet);
    }
    rptAlphabets.DataSource = alphabets;
    rptAlphabets.DataBind();
}

protected void Alphabet_Click(object sender, EventArgs e)
{
    LinkButton lnkAlphabet = (LinkButton)sender;
    ViewState["CurrentAlphabet"] = lnkAlphabet.Text;
    this.GenerateAlphabets();
    this.BindDataList();
}
}
