﻿Imports System.Data
Imports System.Data.SqlClient
Imports System.Configuration
Partial Class VB
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(sender As Object, e As EventArgs) Handles Me.Load
        If Not Me.IsPostBack Then
            Dim ds As New DataSet()
            ds.ReadXml(Server.MapPath("~/Customers.xml"))
            gvCustomers.DataSource = ds.Tables(0)
            gvCustomers.DataBind()
        End If
    End Sub


    Protected Sub Bulk_Insert(sender As Object, e As EventArgs)
        Dim dt As New DataTable()
        dt.Columns.AddRange(New DataColumn(2) {
                            New DataColumn("Id", GetType(Integer)),
                            New DataColumn("Name", GetType(String)),
                            New DataColumn("Country", GetType(String))})
        For Each row As GridViewRow In gvCustomers.Rows
            If TryCast(row.FindControl("CheckBox1"), CheckBox).Checked Then
                Dim id As Integer = Integer.Parse(row.Cells(1).Text)
                Dim name As String = row.Cells(2).Text
                Dim country As String = row.Cells(3).Text
                dt.Rows.Add(id, name, country)
            End If
        Next
        If dt.Rows.Count > 0 Then
            Dim consString As String = ConfigurationManager.ConnectionStrings("constr").ConnectionString
            Using con As New SqlConnection(consString)
                con.Open()
                Using sqlTransaction As SqlTransaction = con.BeginTransaction()
                    Using sqlBulkCopy As New SqlBulkCopy(con, SqlBulkCopyOptions.Default, sqlTransaction)
                        'Set the database table name
                        sqlBulkCopy.DestinationTableName = "dbo.Customers"

                        '[OPTIONAL]: Map the DataTable columns with that of the database table
                        sqlBulkCopy.ColumnMappings.Add("Id", "CustomerId")
                        sqlBulkCopy.ColumnMappings.Add("Name", "Name")
                        sqlBulkCopy.ColumnMappings.Add("Country", "Country")
                        Try
                            sqlBulkCopy.WriteToServer(dt)
                            sqlTransaction.Commit()
                        Catch
                            sqlTransaction.Rollback()
                        End Try
                    End Using
                End Using
                con.Close()
            End Using
        End If
    End Sub
End Class

