﻿using System;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;


public partial class CS : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.IsPostBack)
        {
            DataSet ds = new DataSet();
            ds.ReadXml(Server.MapPath("~/Customers.xml"));
            gvCustomers.DataSource = ds.Tables[0];
            gvCustomers.DataBind();
        }
    }

    protected void Bulk_Insert(object sender, EventArgs e)
    {
        DataTable dt = new DataTable();
        dt.Columns.AddRange(new DataColumn[3] {
                        new DataColumn("Id", typeof(int)),
                        new DataColumn("Name", typeof(string)),
                        new DataColumn("Country",typeof(string)) });
        foreach (GridViewRow row in gvCustomers.Rows)
        {
            if ((row.FindControl("CheckBox1") as CheckBox).Checked)
            {
                int id = int.Parse(row.Cells[1].Text);
                string name = row.Cells[2].Text;
                string country = row.Cells[3].Text;
                dt.Rows.Add(id, name, country);
            }
        }
        if (dt.Rows.Count > 0)
        {
            string consString = ConfigurationManager.ConnectionStrings["constr"].ConnectionString;
            using (SqlConnection con = new SqlConnection(consString))
            {
                con.Open();
                using (SqlTransaction sqlTransaction = con.BeginTransaction())
                {
                    using (SqlBulkCopy sqlBulkCopy = new SqlBulkCopy(con, SqlBulkCopyOptions.Default, sqlTransaction))
                    {
                        //Set the database table name
                        sqlBulkCopy.DestinationTableName = "dbo.Customers";

                        //[OPTIONAL]: Map the DataTable columns with that of the database table
                        sqlBulkCopy.ColumnMappings.Add("Id", "CustomerId");
                        sqlBulkCopy.ColumnMappings.Add("Name", "Name");
                        sqlBulkCopy.ColumnMappings.Add("Country", "Country");
                        try
                        {
                            sqlBulkCopy.WriteToServer(dt);
                            sqlTransaction.Commit();
                        }
                        catch
                        {
                            sqlTransaction.Rollback();
                        }
                    }
                }
                con.Close();
            }
        }
    }
}