﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using System.Web.Script.Serialization;
using Upload_Display_TinyMCE_jQuery_MVC.Models;

namespace Upload_Display_TinyMCE_jQuery_MVC.Controllers
{
    public class HomeController : Controller
    {
        // GET: Home
        public ActionResult Index()
        {
            return View();
        }


        [HttpPost]
        [ValidateInput(false)]
        public ActionResult Index(string richText)
        {
            ViewBag.RichText = richText;
            return View();
        }

        [HttpPost]
        public ActionResult UploadFiles()
        {
            //Fetch the Uploaded File.
            HttpPostedFileBase postedFile = Request.Files[0];

            //Set the Folder Path.
            string folderPath = Server.MapPath("~/Uploads/");

            //Set the File Name.
            string fileName = Path.GetFileName(postedFile.FileName);

            //Save the File in Folder.
            postedFile.SaveAs(folderPath + fileName);

            return Content("/Uploads/" + fileName);
        }
    }
}
